# -*- coding: utf-8 -*-
from math import *
import numpy as np
import matplotlib.pyplot as plt
import csv

##############################
## RECUPERATION DES DONNEES ##
##############################

nom_fichier = "NOM_DU_FICHIER.txt" # LE FICHIER A EXPORTER DOIT AVOIR TOUTE LES GRANDEURS MESUREES EXPORTEES !!!
path="CHEMIN DU DOSSIER AVEC DES \\ AU LIEU DES \ et finir par des \\ " # CHEMIN DU DOSSIER AVEC DES \\ au lieu des \ et finir par des \\ 
l_temps_brute, l_consigne_brute, l_position_brute, l_commande_brute, l_courant_brute, l_vitesse_axe_brute, l_vitesse_moteur = [], [], [], [], [], [], []  # Temps  Consigne  Position  Commande   Courant  Vit. Axe    Moteur
t_i, t_f = 0.0, XXXXX #Bornes inférieur et supérieur du temps. A DEFINIR POUR CHAQUE ESSAI !!!!
with open(path+nom_fichier, 'r', encoding='cp1252') as f:
    lines = [line.replace('      ', ',') for line in f]
    lines = [line.replace('     ', ',') for line in lines] # si jamais il y a des signes '-'
    lines = [line.replace('    ', ',') for line in lines] # si jamais il y a des signes '-'
    lines = [line.replace('   ', ',') for line in lines] # si jamais il y a des signes '-'
    lines = [line.replace('  ', ',') for line in lines] # si jamais il y a des signes '-'
    reader = csv.reader(lines, delimiter=',')  # <--- attention au delimiter
    # Sauter les 2 premières lignes qui correspondent au descriptif de l'essai
    for _ in range(2):
        next(reader)
        
    for row in reader:
        k = 0
        for val in row:
            if val != '':
                if k == 0:
                    l_temps_brute.append(float(val.replace(",", ".")))
                elif k == 1:
                    l_consigne_brute.append(float(val.replace(",", ".")))
                elif k == 2:
                    l_position_brute.append(float(val.replace(",", ".")))
                elif k == 3:
                    l_commande_brute.append(float(val.replace(",", ".")))
                elif k == 4:
                    l_courant_brute.append(float(val.replace(",", ".")))
                elif k == 5:
                    l_vitesse_axe_brute.append(float(val.replace(",", ".")))
                else:
                    l_vitesse_moteur.append(float(val.replace(",", ".")))
                k+=1
            else: val=0.0
N_brute = len(l_temps_brute)

i, i_min, i_max = 0, 0, 0

while i_min == 0:
    if l_temps_brute[i] > t_i:
        i_min = i
    i+=1
while i_max == 0:
    if l_temps_brute[i] >= t_f:
        i_max = i
    i += 1

l_temps, l_consigne, l_position, l_commande, l_courant, l_vitesse_axe, l_vitesse_moteur = l_temps_brute[i_min:i_max], l_consigne_brute[i_min:i_max], l_position_brute[i_min:i_max], l_commande_brute[i_min:i_max], l_courant_brute[i_min:i_max], l_vitesse_axe_brute[i_min:i_max], l_vitesse_moteur[i_min:i_max]

N= len(l_temps)
#####################################
## FIN DE RECUPERATION DES DONNEES ##
#####################################

#courbe de consigne
plt.figure("consigne")
plt.plot(l_temps,l_consigne,"k",label="consigne")
plt.xlabel("temps (ms)")
plt.ylabel("consigne (degrés)")
plt.legend()
plt.grid()
plt.show()

#courbe de position
plt.figure("position")
plt.plot(l_temps,l_position,"g",label="position")
plt.xlabel("temps (ms)")
plt.ylabel("position (degrés)")
plt.legend()
plt.grid()
plt.show()

#courbe de commande
plt.figure("commande")
plt.plot(l_temps,l_commande,"c",label="commande")
plt.xlabel("temps (ms)")
plt.ylabel("commande (V)")
plt.legend()
plt.grid()
plt.show()

#courbe de courant
plt.figure("courant")
plt.plot(l_temps,l_courant,"r",label="courant")
plt.xlabel("temps (ms)")
plt.ylabel("courant (mA)")
plt.legend()
plt.grid()
plt.show()

#courbe de vitesse de l'axe
plt.figure("vitesse axe")
plt.plot(l_temps,l_vitesse_axe,"y",label="vitesse axe")
plt.xlabel("temps (ms)")
plt.ylabel("vitesse axe (rad/s)")
plt.legend()
plt.grid()
plt.show()

#courbe de vitesse moteur
plt.figure("vitesse moteur")
plt.plot(l_temps,l_vitesse_moteur,"b",label="vitesse moteur")
plt.xlabel("temps (ms)")
plt.ylabel("vitesse moteur (rad/s)")
plt.legend()
plt.grid()
plt.show()

#courbe de consigne et de position
plt.figure("consigne")
plt.plot(l_temps,l_consigne,"k",label="consigne")
plt.plot(l_temps,l_position,"g",label="position")
plt.xlabel("temps (ms)")
plt.ylabel("consigne et positions (degrés)")
plt.legend()
plt.grid()
plt.show()

#courbe de vitesse de l'axe et du moteur
plt.figure("vitesse axe et moteur")
plt.plot(l_temps,l_vitesse_axe,"y",label="vitesse axe")
plt.plot(l_temps,l_vitesse_moteur,"b",label="vitesse moteur")
plt.xlabel("temps (ms)")
plt.ylabel("vitesse axe et moteur (rad/s)")
plt.legend()
plt.grid()
plt.show()

#courbe de vitesse moteur
plt.figure("vitesse moteur")
plt.plot(l_temps,l_vitesse_moteur,"b",label="vitesse moteur")
plt.xlabel("temps (ms)")
plt.ylabel("vitesse moteur (rad/s)")
plt.legend()
plt.grid()
plt.show()

#courbe de TOUTES LES COURBES
plt.figure("TOUTES LES COURBES")
plt.plot(l_temps,l_consigne,"k",label="consigne")
plt.plot(l_temps,l_position,"g",label="position")
plt.plot(l_temps,l_commande,"c",label="commande")
plt.plot(l_temps,l_courant,"r",label="courant")
plt.plot(l_temps,l_vitesse_axe,"y",label="vitesse axe")
plt.plot(l_temps,l_vitesse_moteur,"b",label="vitesse moteur")
plt.xlabel("temps (ms)")
plt.legend()
plt.grid()
plt.show()

